/*
 * Decompiled with CFR 0.152.
 */
package acmx.menu;

import acm.program.ProgramMenuBar;
import acmx.menu.ExtendedMenuListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class MenuExtensions {
    private MenuExtensions() {
    }

    public static void extendMenuBar(ProgramMenuBar menuBar) {
        JMenu fileMenu = MenuExtensions.findMenu(menuBar, "File");
        if (fileMenu == null) {
            return;
        }
        ExtendedMenuListener listener = new ExtendedMenuListener(menuBar);
        JMenuItem exportAppletItem = new JMenuItem("Export Applet...");
        exportAppletItem.setActionCommand("Export Applet");
        exportAppletItem.setEnabled(true);
        exportAppletItem.addActionListener(listener);
        JMenuItem submitProjectItem = new JMenuItem("Submit Project...");
        submitProjectItem.setActionCommand("Submit Project");
        submitProjectItem.setEnabled(true);
        submitProjectItem.addActionListener(listener);
        JMenuItem quitItem = null;
        int itemCount = fileMenu.getItemCount();
        if (itemCount > 0 && (quitItem = fileMenu.getItem(itemCount - 1)) != null && !"Quit".equals(quitItem.getActionCommand())) {
            quitItem = null;
        }
        if (quitItem != null) {
            fileMenu.remove(quitItem);
        }
        fileMenu.add(exportAppletItem);
        fileMenu.add(submitProjectItem);
        fileMenu.addSeparator();
        if (quitItem != null) {
            fileMenu.add(quitItem);
        }
    }

    public static void updateMenuBar(ProgramMenuBar menuBar) {
    }

    private static JMenu findMenu(ProgramMenuBar menuBar, String label) {
        int nMenus = menuBar.getMenuCount();
        int i = 0;
        while (i < nMenus) {
            JMenu menu = menuBar.getMenu(i);
            if (label.equals(menu.getText())) {
                return menu;
            }
            ++i;
        }
        return null;
    }
}

